<?php
header('Content-Type: application/json');
require 'connection.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'status' => 'error',
        'message' => 'Only POST method allowed'
    ]);
    exit;
}

$login_id  = $_POST['login_id'] ?? '';
$password  = $_POST['password'] ?? '';
$client_id = $_POST['client_id'] ?? '';

if (!$login_id || !$password || !$client_id) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'login_id, password and client_id required'
    ]);
    exit;
}

$stmt = $conn->prepare("
    SELECT *
    FROM uni_faculties
    WHERE login_id = ?
    AND deleted_at IS NULL
    LIMIT 1
");
$stmt->bind_param("s", $login_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid credentials'
    ]);
    exit;
}

$user = $result->fetch_assoc();

if (!password_verify($password, $user['password'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid credentials'
    ]);
    exit;
}

$faculty_id = $user['id'];

$allocStmt = $conn->prepare("
    SELECT id
    FROM uni_faculty_allocations
    WHERE faculty_id = ?
    AND client_id = ?
    AND deleted_at IS NULL
    LIMIT 1
");
$allocStmt->bind_param("ii", $faculty_id, $client_id);
$allocStmt->execute();
$allocResult = $allocStmt->get_result();

if ($allocResult->num_rows === 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Faculty not assigned to this institute'
    ]);
    exit;
}

unset($user['password'], $user['security_code']);

echo json_encode([
    'status' => 'success',
    'faculty' => $user
]);

$stmt->close();
$allocStmt->close();
$conn->close();
