<?php

header('Content-Type: application/json');
require 'connection.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode([
        'status' => 'error',
        'message' => 'Only GET method allowed'
    ]);
    exit;
}

$client_id   = isset($_GET['client_id']) ? intval($_GET['client_id']) : 0;
$course_id   = isset($_GET['course_id']) ? intval($_GET['course_id']) : 0;
$year_id     = isset($_GET['year_id']) ? intval($_GET['year_id']) : 0;
$division_id = isset($_GET['division_id']) ? intval($_GET['division_id']) : 0;

if (!$client_id || !$course_id || !$year_id || !$division_id) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing required parameters'
    ]);
    exit;
}

$stmtSubject = $conn->prepare("
    SELECT id
    FROM uni_subjects
    WHERE client_id = ?
      AND course_id = ?
      AND year_id = ?
      AND division_id = ?
      AND deleted_at IS NULL
    LIMIT 1
");

$stmtSubject->bind_param("iiii", $client_id, $course_id, $year_id, $division_id);
$stmtSubject->execute();
$resSubject = $stmtSubject->get_result();

$subject_id = null;
if ($resSubject->num_rows > 0) {
    $subject_id = $resSubject->fetch_assoc()['id'];
}
$stmtSubject->close();

$today = date('Y-m-d');

$sql = "
SELECT
    s.id              AS student_id,
    s.student_uid,
    s.enrollment_no,
    s.name,
    a.roll_no,
    al.status         AS attendance_status

FROM uni_student_academic a
JOIN uni_stud_data s
    ON s.id = a.student_id

LEFT JOIN uni_class_attend_log al
    ON al.student_id = s.id
   AND al.subject_id = ?
   AND al.attendance_date = ?
   AND al.client_id = ?

WHERE a.client_id   = ?
  AND s.course_id   = ?
  AND a.year_id     = ?
  AND a.division_id = ?
  AND a.status      = 'active'
  AND s.status      = 'active'

ORDER BY a.roll_no ASC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param(
    "isiiiii",
    $subject_id,
    $today,
    $client_id,
    $client_id,
    $course_id,
    $year_id,
    $division_id
);

$stmt->execute();
$result = $stmt->get_result();

$students = [];

while ($row = $result->fetch_assoc()) {
    $students[] = [
        'student_id'        => $row['student_id'],
        'student_uid'       => $row['student_uid'],
        'enrollment_no'     => $row['enrollment_no'],
        'roll_no'           => $row['roll_no'],
        'name'              => $row['name'],
        'attendance_status' => $row['attendance_status']
    ];
}

$stmt->close();
$conn->close();

echo json_encode([
    'status'      => 'success',
    'subject_id'  => $subject_id,
    'date'        => $today,
    'students'    => $students
]);
